{-*- Mode:Text; Tab-width:4 -*-}
{*                                                                       *}
{*                                                                       *}
{*                      RESTRICTED RIGHTS LEGEND                         *}
{*                                                                       *}
{* Use, duplication, or disclosure by the Government is subject to       *}
{* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  *}
{* Technical Data and Computer Software clause at 252.227-7013.          *}
{*                                                                       *}
{*                    TEXAS INSTRUMENTS INCORPORATED.                    *}
{*                            P.O. BOX 149149                            *}
{*                         AUSTIN, TEXAS 78714-9149                      *}
{*                              MS 2151                                  *}
{*                                                                       *}
{*  Copyright (C)   1987,1988,1989,1990 Texas Instruments Incorporated.  *}
{*  All rights reserved.                                                 *}
{*                                                                       *}


{ 3-13-89  BJ  Added function def for physical_to_virtual. }
UNIT Primitives;

{$SETC debug := TRUE}			{set at TRUE for debugging window}

INTERFACE

USES Memtypes, Quickdraw, OSIntf, ToolIntf, PackIntf,
    {$LOAD} PasLibIntf;

  CONST
    mmu32bit	= $0cb2;				{ low memory address of ROM 32 bit mode flag }  
    mmu24mode	= 0;
	mmu32mode	= 1;
  
	appleID 	 = 128; 			   {resource IDs/menu IDs for Apple, File and Edit menus}
	fileID		 = 129;
	editID		 = 130;
	scrnID       = 131;
	specialID	 = 133;
	
	appleM		 = 1;				   {index for each menu in myMenus (array of menu handles)}
	fileM		 = 2;
	editM        = 3;
	scrnM		 = 4;
    specialM     = 5;
	
	{$IFC debug} 
	debugM		= 6;
	debugID		= 132;
	menuCount	= 6;				   {total number of menus}
	{$ELSEC}
	debugM      = 0;
	debugID     = 0;
	menuCount	= 5;				   {total number of menus}
	{$ENDC}

	windowID	 = 128; 			   {resource ID for application's window}
	
	undoCommand  = 1;				   {menu item numbers identifying commands in Edit menu}
	cutCommand	 = 3;
	copyCommand  = 4;
	pasteCommand = 5;
	clearCommand = 6;

	coldboot	=	1;
	warmboot	=	2;
	forcecrash	=	3;

	aboutMeCommand = 1; 			   {menu item in apple menu for About sample item}
	
  TYPE
    LongPtr	= ^LongInt;				{special ptr type that points to 4-byte word}

  VAR
    CmdBlkPtr:	 Ptr;				{Ptr to the command block.}
	ParmPtr:	 Ptr;				{Ptr to the start of the Parameters in the command block}
	StatusPtr:	 Ptr;				{Ptr to the status byte of the command block}
	
	myMenus:	 ARRAY [1..menuCount] OF MenuHandle; {array of handles to the menus}

	
  {PROCEDURE Debugger; INLINE $A9FF;}
  {PROCEDURE DebugStr(str: str255); INLINE $ABFF;}
  {PROCEDURE SwapMMUMode (VAR mode: Byte); INLINE $205F,$3010,$A05D,$3080;}
  FUNCTION  GetCommInit(aPtr: ptr): ptr;
  PROCEDURE FetchCmd(aPtr: Ptr; VAR Cmd, Ctype : Integer; VAR ParmPtr, CmdBlkPtr : Ptr); 
  PROCEDURE BitSwap(aPtr, bPtr : Ptr; length : Longint);
  PROCEDURE ByteSwap(aPtr, bPtr : Ptr; length : Integer);
  PROCEDURE MoveWrds(aPtr, bPtr : Ptr; length : Integer);
  PROCEDURE IntegerSwap(aPtr, bPtr : Ptr; length : Integer);
  PROCEDURE Return2Parms(aPtr: Ptr; a, b: Integer);
  FUNCTION  XtractID(aByte : Byte) : INTEGER;	
  PROCEDURE InlineSwap(aLongInt : LongInt); INLINE $205F, $2010, $E158, $4840, $E158, $2080;
  PROCEDURE CmdComplete(aPtr: Ptr);
  {Sets bit 6 in the byte pointed to by aPtr - the status byte. Loops until bit is set.} 
    INLINE $205F, $0010, $0040, $0810, $0006, $67F6;
  PROCEDURE InputComplete(aptr: Ptr);
  {Sets bit 7 in the byte pointed to by aPtr - the status byte. Loops until bit is set.}
    INLINE $205F, $0010, $0080, $0810, $0007, $67F6;
  PROCEDURE PrtWarnMesg(CmdType : Str255; BadCmd : Integer);
  PROCEDURE PrtErrorMesg(errno,arg: Integer);
  FUNCTION min(val1,val2 : Integer) : Integer;
  FUNCTION max(val1,val2 : Integer) : Integer;
  
  PROCEDURE RPC_Server(aPtr : Ptr);
  PROCEDURE RPC_Init;
  PROCEDURE Set24Mode;
  PROCEDURE Set32Mode;
  PROCEDURE xxSetVBuf;
  FUNCTION physical_to_virtual(pointer : ptr) : ptr;
  
IMPLEMENTATION

  PROCEDURE Set24Mode;
  VAR
  	MMU:	SignedByte;
  BEGIN
    if Ptr(mmu32bit)^ = mmu32mode then
		begin
		  	MMU := mmu24mode;
			SwapMMUMode(MMU);
		end
  END;
    	
  PROCEDURE Set32Mode;
  VAR
  	MMU:	SignedByte;
  BEGIN
    if Ptr(mmu32bit)^ = mmu24mode then
		begin
  			MMU := mmu32mode;
			SwapMMUMode(MMU);
		end
  END;
  
  PROCEDURE RPC_Server(aPtr : Ptr); EXTERNAL;
  PROCEDURE RPC_Init; EXTERNAL;
    	
  FUNCTION GetCommInit(aPtr: ptr): ptr;
  {Fetch the Command Initiate ptr from the 8 bytes at aPtr, includes byte swap and address fix.}
    EXTERNAL;

  PROCEDURE FetchCmd(aPtr: Ptr; VAR Cmd, Ctype : Integer; VAR ParmPtr, CmdBlkPtr : Ptr); 
    EXTERNAL;
	
  PROCEDURE BitSwap(aPtr, bPtr : Ptr; length : Longint);
  {Bit swaps and copies the 32 bit data at aPtr and moves it to bPtr. 
   Length is the number of longwords of data to copy.}
  	EXTERNAL;
	
  PROCEDURE ByteSwap(aPtr, bPtr : Ptr; length : Integer);
  {Swaps bytes starting at aPtr and moves them to bPtr. 
   Length is the count, and must be a multiple of 4.}
    EXTERNAL;
	
  PROCEDURE MoveWrds(aPtr, bPtr: Ptr; length: Integer);
  {Moves 32 bit words from aPtr to bPtr}
  {Length is the count in bytes and must be a multiple of 4.}
  	EXTERNAL;
	
  PROCEDURE IntegerSwap(aPtr, bPtr : Ptr; length : Integer);
  {Swaps integers - 2byte words - at aPtr and moves them to bPtr. Length is the count.}
  	EXTERNAL;  	
  	
  PROCEDURE Return2Parms(aPtr: Ptr; a, b: Integer);
    EXTERNAL;
	
  FUNCTION XtractID(aByte : Byte) : INTEGER; 	EXTERNAL;
	{Structure of the Byte is : bit 7  6  not used
									5  4  3  Formatter
									2  1  not used
									0  Device }

  PROCEDURE PrtWarnMesg(CmdType : Str255; BadCmd : Integer);
  {Send an alert message that an illegal command was received}
  	CONST
	  BadCmdAlert = 128;
  	VAR
	  temp: 		Integer;
	  cmdString:   	Str255;
	  MMU:			SignedByte;
    BEGIN
	  MMU := mmu24mode ;
	  if Ptr(mmu32bit)^ = mmu32mode then
			  SwapMMUMode(MMU);
      if (BadCmd <> 0) then begin
	  		NumToString(longint(BadCmd) ,cmdString);
	  		ParamText(CmdType,cmdString, '','')
	  end else
			ParamText(CmdType, '', '', '') ;
	  temp := NoteAlert(BadCmdAlert, NIL);	{ignore result}
	  if MMU = mmu32mode then
		  SwapMMUMode(MMU);
	END;

  PROCEDURE PrtErrorMesg(errno,arg :integer) ;
    CONST
		ErrorAlert	=	100 ;
	VAR
		astring:		Handle ;
		MMU:		SignedByte ;
		cmdString:   	Str255;
		bogus:		integer ;
	BEGIN
	  MMU := mmu24mode ;
	  if Ptr(mmu32bit)^ = mmu32mode then
			  SwapMMUMode(MMU);
 	  astring := GetResource('STR ', errno) ;
	  if (arg <> 0) then begin
		NumToString(longint(arg), cmdString);
		ParamText(StringHandle(astring)^^, cmdString, '', '');
        end
      else
	    ParamText(StringHandle(astring)^^, '', '', '') ;
	  bogus := StopAlert(ErrorAlert, nil) ;
	  if MMU = mmu32mode then
		  SwapMMUMode(MMU);
	END;		
	
  FUNCTION min(val1,val2 : Integer) : Integer;
  	BEGIN
		IF val1 < val2 THEN min := val1 ELSE min := val2;
    END;
	
  FUNCTION max(val1,val2 : Integer) : Integer;
  	BEGIN
		IF val1 > val2 THEN max := val1 ELSE max := val2;
    END;

	PROCEDURE xxSetVBuf ;
    BEGIN
	    PLSetVBuf(output, nil, 64, 100);
    END ;
	
	FUNCTION physical_to_virtual(pointer : ptr) : ptr; EXTERNAL;
END.